using System;
using System.Xml;

using gov.va.med.vbecs.DAL.VistALink.OpenLibrary;

namespace gov.va.med.vbecs.DAL.VistALink.OpenLibrary.Messages
{
	/// <summary>
	/// Base class for all VistALink fault messages modeled 
	/// after SOAP fault messages. 
	/// </summary>
	public abstract class BaseFaultMessage : VistALinkMessage
	{
		FaultInfo _faultInfo;

		/// <summary>
		/// Contstructor specifying minimal required fault message parameters. 
		/// </summary>
		/// <param name="messageType">VistALink message type.</param>
		/// <param name="sourceXSD">VistALink message XSD name.</param>
		/// <param name="faultInfo">Fault info object containing information about the fault.</param>
		protected BaseFaultMessage( string messageType, string sourceXSD, FaultInfo faultInfo ) 
			: base( messageType, sourceXSD )
		{
			if( faultInfo == null )
				throw( new ArgumentNullException( "faultInfo" ) );

			_faultInfo = faultInfo;
		} 

		/// <summary>
		/// Standard VistALink message deserialization constructor. 
		/// Allows recreating message object from XML document.
		/// </summary>
		/// <param name="messageType">VistALink message type.</param>
		/// <param name="sourceXSD">VistALink message XSD name.</param>
		/// <param name="sourceDoc">Source XML document.</param>
		protected BaseFaultMessage( string messageType, string sourceXSD, XmlDocument sourceDoc )
			: base( messageType, sourceXSD, sourceDoc )
		{
			_faultInfo = new FaultInfo( sourceDoc.DocumentElement );
		}

		/// <summary>
		/// Standard VistALink message XML serialization method, 
		/// translating message object into XML representation.
		/// </summary>
		/// <param name="writer">XmlWriter to use.</param>
		protected override void WriteXmlMessageBody( XmlWriter writer )
		{
			if( writer == null )
				throw( new ArgumentNullException( "writer" ) );

			_faultInfo.WriteFaultInfoToXml( writer );
		}
		
		/// <summary>
		/// Fault info object containing information about the fault occured.
		/// </summary>
		public FaultInfo FaultInfo
		{
			get
			{
				return _faultInfo;
			}
		}
	}
}
